/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class NameQuery
extends Query {
    private final Name nodeName;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;

    public NameQuery(Name nodeName, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this.nodeName = nodeName;
        this.version = version;
        this.nsMappings = nsMappings;
    }

    public Name getName() {
        return this.nodeName;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.version.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            BooleanQuery name = new BooleanQuery();
            name.add((Query)new JackrabbitTermQuery(new Term(FieldNames.NAMESPACE_URI, this.nodeName.getNamespaceURI())), BooleanClause.Occur.MUST);
            name.add((Query)new JackrabbitTermQuery(new Term(FieldNames.LOCAL_NAME, this.nodeName.getLocalName())), BooleanClause.Occur.MUST);
            return name;
        }
        try {
            return new JackrabbitTermQuery(new Term(FieldNames.LABEL, this.nsMappings.translateName(this.nodeName)));
        }
        catch (IllegalNameException e) {
            throw Util.createIOException((Throwable)((Object)e));
        }
    }

    public void extractTerms(Set terms) {
    }

    public String toString(String field) {
        return "name() = " + this.nodeName.toString();
    }
}

