/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Preconditions;

abstract class AbstractTypeDefinition {
    private static final String[] NO_STRINGS = new String[0];
    protected final Tree definition;
    protected final NamePathMapper mapper;

    protected AbstractTypeDefinition(Tree definition, NamePathMapper mapper) {
        this.definition = Preconditions.checkNotNull(definition);
        this.mapper = Preconditions.checkNotNull(mapper);
    }

    protected boolean getBoolean(@NotNull String name) {
        PropertyState property = this.definition.getProperty(Preconditions.checkNotNull(name));
        return property != null && property.getValue(Type.BOOLEAN) != false;
    }

    @Nullable
    protected String getString(@NotNull String oakName) {
        return this.getValue(oakName, Type.STRING);
    }

    @Nullable
    protected String[] getStrings(@NotNull String oakName) {
        return this.getValues(oakName, Type.STRING);
    }

    @Nullable
    protected String getName(@NotNull String oakName) {
        return this.getValue(oakName, Type.NAME);
    }

    @Nullable
    protected String[] getNames(@NotNull String oakName) {
        return this.getValues(oakName, Type.NAME);
    }

    private String getValue(String oakName, Type<String> type) {
        PropertyState property = this.definition.getProperty(Preconditions.checkNotNull(oakName));
        if (property != null) {
            return property.getValue(type);
        }
        return null;
    }

    private String[] getValues(String oakName, Type<String> type) {
        String[] values = null;
        PropertyState property = this.definition.getProperty(Preconditions.checkNotNull(oakName));
        if (property != null) {
            int n = property.count();
            if (n > 0) {
                values = new String[n];
                for (int i = 0; i < n; ++i) {
                    values[i] = property.getValue(type, i);
                }
            } else {
                values = NO_STRINGS;
            }
        }
        return values;
    }
}

