/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.json.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.json.jackson.SimpleNameIntrospector;

public class CacheService
implements LogEnabled {
    AnnotationIntrospector primary;
    Map<String, FilterProvider> filters = new ConcurrentHashMap<String, FilterProvider>();
    private static Logger logger;

    public CacheService(AnnotationIntrospector primary) {
        this.primary = primary;
    }

    <T> void removeFilter(Class<T> filterClass, Boolean excludeType) {
        if (filterClass == null) {
            return;
        }
        if (this.filters.containsKey(filterClass.getName())) {
            logger.debug("removing filter: " + filterClass.getName());
            this.removeCustomIntrospectorWithExternalFilterId(filterClass, excludeType);
            SimpleFilterProvider smpfilter = (SimpleFilterProvider)this.filters.get(filterClass.getName());
            smpfilter.removeFilter(filterClass.getName());
            this.filters.remove(filterClass.getName());
        }
    }

    <T> void removeCustomIntrospectorWithExternalFilterId(Class<T> externalFilterId, Boolean excludeType) {
        if (this.primary instanceof SimpleNameIntrospector && externalFilterId != null) {
            ((SimpleNameIntrospector)this.primary).removeFilteredClass(externalFilterId);
            if (excludeType.booleanValue()) {
                ((SimpleNameIntrospector)this.primary).removeExternalFilterExcludeClass(externalFilterId);
            }
        }
    }

    void cleanSerializerCache(ObjectMapper mapper) {
        int cachedSerProvs;
        if (mapper.getSerializerProvider() instanceof DefaultSerializerProvider && (cachedSerProvs = ((DefaultSerializerProvider)mapper.getSerializerProvider()).cachedSerializersCount()) > 0) {
            ((DefaultSerializerProvider)mapper.getSerializerProvider()).flushCachedSerializers();
        }
    }

    public Map<String, FilterProvider> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, FilterProvider> filters) {
        this.filters = filters;
    }

    public void enableLogging(Logger logger) {
        CacheService.logger = logger;
    }
}

