/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.turbine.annotation.AnnotationProcessor;
import org.apache.turbine.pipeline.Pipeline;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.Valve;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.TurbineException;

public class TurbinePipeline
implements Pipeline,
ValveContext {
    public static final String CLASSIC_PIPELINE = "WEB-INF/conf/turbine-classic-pipeline.xml";
    protected String name;
    protected Valve[] valves = new Valve[0];
    protected ThreadLocal<Integer> state = new ThreadLocal();

    @Override
    public void initialize() throws Exception {
        if (this.state == null) {
            this.state = new ThreadLocal();
        }
        for (int i = 0; i < this.valves.length; ++i) {
            AnnotationProcessor.process(this.valves[i]);
            this.valves[i].initialize();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValve(Valve valve) {
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] results = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = valve;
            this.valves = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Valve[] getValves() {
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] results = new Valve[this.valves.length];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValve(Valve valve) {
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            int index = -1;
            for (int i = 0; i < this.valves.length; ++i) {
                if (valve != this.valves[i]) continue;
                index = i;
                break;
            }
            if (index < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Valve[] results = new Valve[this.valves.length - 1];
            int n = 0;
            for (int i = 0; i < this.valves.length; ++i) {
                if (i == index) continue;
                results[n++] = this.valves[i];
            }
            this.valves = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void invoke(PipelineData pipelineData) throws TurbineException, IOException {
        this.state.set(0);
        this.invokeNext(pipelineData);
    }

    @Override
    public void invokeNext(PipelineData pipelineData) throws TurbineException, IOException {
        Integer current = this.state.get();
        int subscript = current;
        if (subscript < this.valves.length) {
            this.state.set(subscript + 1);
            this.valves[subscript].invoke(pipelineData, this);
        }
    }
}

