/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.batik.ext.awt.image.codec.ImageEncodeParam;
import org.apache.batik.ext.awt.image.codec.ImageEncoderImpl;
import org.apache.batik.ext.awt.image.codec.SeekableOutputStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        Object object2;
        Object object3;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        Object object4;
        byte[] byArray;
        byte[] byArray2;
        int n16;
        int n17;
        int n18 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n19 = renderedImage.getMinX();
        int n20 = renderedImage.getMinY();
        int n21 = renderedImage.getWidth();
        int n22 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        for (n17 = 1; n17 < nArray.length; ++n17) {
            if (nArray[n17] == nArray[0]) continue;
            throw new Error("TIFFImageEncoder0");
        }
        n17 = sampleModel.getNumBands();
        if ((nArray[0] == 1 || nArray[0] == 4) && n17 != 1) {
            throw new Error("TIFFImageEncoder1");
        }
        int n23 = sampleModel.getDataType();
        switch (n23) {
            case 0: {
                if (nArray[0] == 1 || nArray[0] != 4 || nArray[0] == 8) break;
                throw new Error("TIFFImageEncoder2");
            }
            case 1: 
            case 2: {
                if (nArray[0] == 16) break;
                throw new Error("TIFFImageEncoder3");
            }
            case 3: 
            case 4: {
                if (nArray[0] == 32) break;
                throw new Error("TIFFImageEncoder4");
            }
            default: {
                throw new Error("TIFFImageEncoder5");
            }
        }
        boolean bl3 = n23 == 2 || n23 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n23 != 0) {
            throw new Error("TIFFImageEncoder6");
        }
        IndexColorModel indexColorModel = null;
        int n24 = 0;
        char[] cArray = null;
        int n25 = -1;
        int n26 = 0;
        int n27 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n16 = indexColorModel.getMapSize();
            if (nArray[0] == 1 && n17 == 1) {
                if (n16 != 2) {
                    throw new IllegalArgumentException("TIFFImageEncoder7");
                }
                byArray2 = new byte[n16];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n16];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n16];
                indexColorModel.getBlues((byte[])object4);
                n25 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (object4[0] & 0xFF) == 0 && (object4[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (object4[0] & 0xFF) == 255 && (object4[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n17 == 1) {
                n25 = 3;
            }
        } else if (colorModel == null) {
            if (nArray[0] == 1 && n17 == 1) {
                n25 = 1;
            } else {
                n25 = 8;
                if (n17 > 1) {
                    n26 = n17 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n25 = 5;
                    break;
                }
                case 6: {
                    n25 = 2;
                    break;
                }
                case 1: {
                    n25 = 7;
                    break;
                }
                case 5: {
                    if (n18 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n25 = 6;
                        break;
                    }
                    n25 = 4;
                    break;
                }
                case 3: {
                    n25 = 6;
                    break;
                }
                default: {
                    n25 = 8;
                }
            }
            if (n25 == 8) {
                n26 = n17 - 1;
            } else if (n17 > 1) {
                n26 = n17 - colorSpace.getNumComponents();
            }
            if (n26 == 1 && colorModel.hasAlpha()) {
                int n28 = n27 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n25 == -1) {
            throw new Error("TIFFImageEncoder8");
        }
        if (n18 == 7) {
            if (n25 == 3) {
                throw new Error("TIFFImageEncoder11");
            }
            if (nArray[0] != 8 || n25 != 2 && n25 != 4 && n25 != 6) {
                throw new Error("TIFFImageEncoder9");
            }
        }
        n16 = -1;
        switch (n25) {
            case 0: {
                n16 = 0;
                break;
            }
            case 1: {
                n16 = 1;
                break;
            }
            case 2: 
            case 8: {
                n16 = 1;
                break;
            }
            case 3: {
                n16 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n24 = indexColorModel.getMapSize();
                byArray2 = new byte[n24];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n24];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n24];
                indexColorModel.getBlues((byte[])object4);
                n15 = 0;
                n14 = n24;
                n13 = 2 * n24;
                cArray = new char[n24 * 3];
                for (n12 = 0; n12 < n24; ++n12) {
                    cArray[n15++] = (char)((byArray2[n12] << 8 | byArray2[n12]) & 0xFFFF);
                    cArray[n14++] = (char)((byArray[n12] << 8 | byArray[n12]) & 0xFFFF);
                    cArray[n13++] = (char)((object4[n12] << 8 | object4[n12]) & 0xFFFF);
                }
                n24 *= 3;
                break;
            }
            case 4: {
                n16 = 2;
                break;
            }
            case 5: {
                n16 = 5;
                break;
            }
            case 6: {
                n16 = 6;
                break;
            }
            case 7: {
                n16 = 8;
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder8");
            }
        }
        if (bl2) {
            n11 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n10 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n11 = n21;
            n10 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        object4 = null;
        if (n18 == 7) {
            object4 = tIFFEncodeParam.getJPEGEncodeParam();
            n15 = object4.getHorizontalSubsampling(0);
            n14 = object4.getVerticalSubsampling(0);
            for (n13 = 1; n13 < n17; ++n13) {
                int n29;
                n12 = object4.getHorizontalSubsampling(n13);
                if (n12 > n15) {
                    n15 = n12;
                }
                if ((n29 = object4.getVerticalSubsampling(n13)) <= n14) continue;
                n14 = n29;
            }
            n13 = 8 * n14;
            if ((n10 = (int)((float)n10 / (float)n13 + 0.5f) * n13) < n13) {
                n10 = n13;
            }
            if (bl2 && (n11 = (int)((float)n11 / (float)(n12 = 8 * n15) + 0.5f) * n12) < n12) {
                n11 = n12;
            }
        }
        n15 = bl2 ? (n21 + n11 - 1) / n11 * ((n22 + n10 - 1) / n10) : (int)Math.ceil((double)n22 / (double)n10);
        long[] lArray = new long[n15];
        long l = (long)Math.ceil((double)nArray[0] / 8.0 * (double)n11 * (double)n17);
        long l2 = l * (long)n10;
        for (int i = 0; i < n15; ++i) {
            lArray[i] = l2;
        }
        if (!bl2) {
            long l3 = n22 - n10 * (n15 - 1);
            lArray[n15 - 1] = l3 * l;
        }
        long l4 = l2 * (long)(n15 - 1) + lArray[n15 - 1];
        long[] lArray2 = new long[n15];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n21}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n22}));
        char[] cArray2 = new char[n17];
        for (int i = 0; i < n17; ++i) {
            cArray2[i] = (char)nArray[i];
        }
        treeSet.add(new TIFFField(258, 3, n17, cArray2));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n18}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n16}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n15, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n17}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n10}));
            treeSet.add(new TIFFField(279, 4, n15, lArray));
        }
        if (cArray != null) {
            treeSet.add(new TIFFField(320, 3, n24, cArray));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n11}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n10}));
            treeSet.add(new TIFFField(324, 4, n15, lArray2));
            treeSet.add(new TIFFField(325, 4, n15, lArray));
        }
        if (n26 > 0) {
            char[] cArray3 = new char[n26];
            for (n9 = 0; n9 < n26; ++n9) {
                cArray3[n9] = (char)n27;
            }
            treeSet.add(new TIFFField(338, 3, n26, cArray3));
        }
        if (n23 != 0) {
            char[] cArray4 = new char[n17];
            cArray4[0] = n23 == 4 ? 3 : (n23 == 1 ? 1 : 2);
            for (n9 = 1; n9 < n17; ++n9) {
                cArray4[n9] = cArray4[0];
            }
            treeSet.add(new TIFFField(339, 3, n17, cArray4));
        }
        JPEGEncodeParam jPEGEncodeParam = null;
        JPEGImageEncoder jPEGImageEncoder = null;
        int n30 = 0;
        if (n18 == 7) {
            n30 = 0;
            switch (n25) {
                case 2: 
                case 3: {
                    n30 = 1;
                    break;
                }
                case 4: {
                    n30 = 2;
                    break;
                }
                case 6: {
                    n30 = 3;
                }
            }
            object3 = renderedImage.getTile(0, 0);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object3, (int)n30);
            TIFFImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n17);
            jPEGEncodeParam.setImageInfoValid(false);
            jPEGEncodeParam.setTableInfoValid(true);
            object2 = new ByteArrayOutputStream();
            jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object2, (JPEGEncodeParam)jPEGEncodeParam);
            jPEGImageEncoder.encode((Raster)object3);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            treeSet.add(new TIFFField(347, 7, ((Object)object).length, object));
            jPEGImageEncoder = null;
        }
        if (n25 == 6) {
            char c = '\u0001';
            char c2 = '\u0001';
            if (n18 == 7) {
                c = (char)object4.getHorizontalSubsampling(0);
                c2 = (char)object4.getVerticalSubsampling(0);
                for (int i = 1; i < n17; ++i) {
                    n8 = (char)object4.getHorizontalSubsampling(i);
                    if (n8 > c) {
                        c = (char)n8;
                    }
                    if ((n7 = (int)((char)object4.getVerticalSubsampling(i))) <= c2) continue;
                    c2 = (char)n7;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new char[]{c, c2}));
            treeSet.add(new TIFFField(531, 3, 1, new int[]{n18 == 7 ? 1 : 2}));
            object = n18 == 7 ? (Object)new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : (Object)new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((object3 = tIFFEncodeParam.getExtraFields()) != null) {
            object2 = new ArrayList<Integer>(treeSet.size());
            object = treeSet.iterator();
            while (object.hasNext()) {
                TIFFField tIFFField = (TIFFField)object.next();
                ((ArrayList)object2).add(new Integer(tIFFField.getTag()));
            }
            n8 = ((TIFFField[])object3).length;
            for (n7 = 0; n7 < n8; ++n7) {
                TIFFField tIFFField = object3[n7];
                Integer n31 = new Integer(tIFFField.getTag());
                if (((ArrayList)object2).contains(n31)) continue;
                treeSet.add(tIFFField);
                ((ArrayList)object2).add(n31);
            }
        }
        int n32 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n32;
        object = null;
        byte[] byArray3 = null;
        File file = null;
        int n33 = 0;
        boolean bl4 = false;
        Deflater deflater = null;
        boolean bl5 = false;
        if (n18 == 1) {
            int n34;
            n6 = 0;
            if (nArray[0] == 16 && lArray2[0] % 2L != 0L) {
                n6 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray[0] == 32 && lArray2[0] % 4L != 0L) {
                n6 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n6;
            }
            for (n34 = 1; n34 < n15; ++n34) {
                lArray2[n34] = lArray2[n34 - 1] + lArray[n34 - 1];
            }
            if (!bl && ((n33 = (int)(lArray2[0] + l4)) & 1) != 0) {
                ++n33;
                bl4 = true;
            }
            this.writeDirectory(n, treeSet, n33);
            if (n6 != 0) {
                for (n34 = 0; n34 < n6; ++n34) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            n6 = 0;
            switch (n18) {
                case 32773: {
                    n6 = (int)(l2 + (l + 127L) / 128L * (long)n10);
                    break;
                }
                case 7: {
                    n6 = 0;
                    if (n25 == 6 && colorModel != null && colorModel.getColorSpace().getType() == 5) {
                        bl5 = true;
                    }
                }
                case 32946: {
                    n6 = (int)l2;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            if (n6 != 0) {
                byArray3 = new byte[n6];
            }
        }
        int[] nArray2 = null;
        float[] fArray = null;
        boolean bl6 = nArray[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n23 == 0 || nArray[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray4 = null;
        if (n18 != 7) {
            if (n23 == 0) {
                byArray4 = new byte[n10 * n11 * n17];
            } else if (bl3) {
                byArray4 = new byte[2 * n10 * n11 * n17];
            } else if (n23 == 3 || n23 == 4) {
                byArray4 = new byte[4 * n10 * n11 * n17];
            }
        }
        int n35 = n20 + n22;
        int n36 = n19 + n21;
        int n37 = 0;
        for (n5 = n20; n5 < n35; n5 += n10) {
            n4 = bl2 ? n10 : Math.min(n10, n35 - n5);
            n3 = n4 * n11 * n17;
            block54: for (n2 = n19; n2 < n36; n2 += n11) {
                int n38;
                int n39;
                int n40;
                Raster raster = renderedImage.getData(new Rectangle(n2, n5, n11, n4));
                boolean bl7 = false;
                if (n18 != 7) {
                    if (bl6) {
                        if (nArray[0] == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray3 = componentSampleModel.getBankIndices();
                            int[] nArray4 = componentSampleModel.getBandOffsets();
                            n40 = componentSampleModel.getPixelStride();
                            n39 = componentSampleModel.getScanlineStride();
                            if (n40 != n17 || (long)n39 != l) {
                                bl7 = false;
                            } else {
                                bl7 = true;
                                for (n38 = 0; bl7 && n38 < n17; ++n38) {
                                    if (nArray3[n38] == 0 && nArray4[n38] == n38) continue;
                                    bl7 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl7 = true;
                            }
                        }
                    }
                    if (!bl7) {
                        if (n23 == 4) {
                            fArray = raster.getPixels(n2, n5, n11, n4, fArray);
                        } else {
                            nArray2 = raster.getPixels(n2, n5, n11, n4, nArray2);
                        }
                    }
                }
                int n41 = 0;
                int n42 = 0;
                switch (nArray[0]) {
                    case 1: {
                        int n43;
                        int n44;
                        if (bl7) {
                            byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n38 = multiPixelPackedSampleModel.getScanlineStride();
                            int n45 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                            if (n38 == (int)l) {
                                System.arraycopy(byArray5, n45, byArray4, 0, (int)l * n4);
                            } else {
                                n44 = 0;
                                for (n43 = 0; n43 < n4; ++n43) {
                                    System.arraycopy(byArray5, n45, byArray4, n44, (int)l);
                                    n45 += n38;
                                    n44 += (int)l;
                                }
                            }
                        } else {
                            int n46 = 0;
                            for (n40 = 0; n40 < n4; ++n40) {
                                for (n39 = 0; n39 < n11 / 8; ++n39) {
                                    n41 = nArray2[n46++] << 7 | nArray2[n46++] << 6 | nArray2[n46++] << 5 | nArray2[n46++] << 4 | nArray2[n46++] << 3 | nArray2[n46++] << 2 | nArray2[n46++] << 1 | nArray2[n46++];
                                    byArray4[n42++] = (byte)n41;
                                }
                                if (n11 % 8 <= 0) continue;
                                n41 = 0;
                                for (n39 = 0; n39 < n11 % 8; ++n39) {
                                    n41 |= nArray2[n46++] << 7 - n39;
                                }
                                byArray4[n42++] = (byte)n41;
                            }
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n4 * ((n11 + 7) / 8));
                            continue block54;
                        }
                        if (n18 == 32773) {
                            int n47 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n37++] = n47;
                            this.output.write(byArray3, 0, n47);
                            continue block54;
                        }
                        if (n18 != 32946) continue block54;
                        int n48 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n37++] = n48;
                        this.output.write(byArray3, 0, n48);
                        continue block54;
                    }
                    case 4: {
                        int n49 = 0;
                        for (n40 = 0; n40 < n4; ++n40) {
                            for (n39 = 0; n39 < n11 / 2; ++n39) {
                                n41 = nArray2[n49++] << 4 | nArray2[n49++];
                                byArray4[n42++] = (byte)n41;
                            }
                            if (n11 % 2 != 1) continue;
                            n41 = nArray2[n49++] << 4;
                            byArray4[n42++] = (byte)n41;
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n4 * ((n11 + 1) / 2));
                            continue block54;
                        }
                        if (n18 == 32773) {
                            n40 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n37++] = n40;
                            this.output.write(byArray3, 0, n40);
                            continue block54;
                        }
                        if (n18 != 32946) continue block54;
                        n40 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n37++] = n40;
                        this.output.write(byArray3, 0, n40);
                        continue block54;
                    }
                    case 8: {
                        int n43;
                        int n44;
                        if (n18 != 7) {
                            if (bl7) {
                                byte[] byArray6 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n38 = componentSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                                int n50 = componentSampleModel.getScanlineStride();
                                if (n50 == (int)l) {
                                    System.arraycopy(byArray6, n38, byArray4, 0, (int)l * n4);
                                } else {
                                    n44 = 0;
                                    for (n43 = 0; n43 < n4; ++n43) {
                                        System.arraycopy(byArray6, n38, byArray4, n44, (int)l);
                                        n38 += n50;
                                        n44 += (int)l;
                                    }
                                }
                            } else {
                                for (n40 = 0; n40 < n3; ++n40) {
                                    byArray4[n40] = (byte)nArray2[n40];
                                }
                            }
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n3);
                            continue block54;
                        }
                        if (n18 == 32773) {
                            n40 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n37++] = n40;
                            this.output.write(byArray3, 0, n40);
                            continue block54;
                        }
                        if (n18 == 7) {
                            long l5 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || jPEGEncodeParam.getWidth() != raster.getWidth() || jPEGEncodeParam.getHeight() != raster.getHeight()) {
                                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)raster, (int)n30);
                                TIFFImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n17);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (JPEGEncodeParam)jPEGEncodeParam);
                            }
                            if (bl5) {
                                WritableRaster writableRaster = null;
                                if (raster instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)raster;
                                } else {
                                    writableRaster = raster.createCompatibleWritableRaster();
                                    writableRaster.setRect(raster);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(raster.createTranslatedChild(0, 0));
                            }
                            long l6 = this.getOffset(this.output);
                            lArray[n37++] = (int)(l6 - l5);
                            continue block54;
                        }
                        if (n18 != 32946) continue block54;
                        n40 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n37++] = n40;
                        this.output.write(byArray3, 0, n40);
                        continue block54;
                    }
                    case 16: {
                        n40 = 0;
                        for (n39 = 0; n39 < n3; ++n39) {
                            n38 = (short)nArray2[n39];
                            byArray4[n40++] = (byte)((n38 & 0xFF00) >> 8);
                            byArray4[n40++] = (byte)(n38 & 0xFF);
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n3 * 2);
                            continue block54;
                        }
                        if (n18 == 32773) {
                            n39 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n37++] = n39;
                            this.output.write(byArray3, 0, n39);
                            continue block54;
                        }
                        if (n18 != 32946) continue block54;
                        n39 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n37++] = n39;
                        this.output.write(byArray3, 0, n39);
                        continue block54;
                    }
                    case 32: {
                        if (n23 == 3) {
                            n39 = 0;
                            for (n38 = 0; n38 < n3; ++n38) {
                                int n51 = nArray2[n38];
                                byArray4[n39++] = (byte)((n51 & 0xFF000000) >> 24);
                                byArray4[n39++] = (byte)((n51 & 0xFF0000) >> 16);
                                byArray4[n39++] = (byte)((n51 & 0xFF00) >> 8);
                                byArray4[n39++] = (byte)(n51 & 0xFF);
                            }
                        } else {
                            n39 = 0;
                            for (n38 = 0; n38 < n3; ++n38) {
                                int n52 = Float.floatToIntBits(fArray[n38]);
                                byArray4[n39++] = (byte)((n52 & 0xFF000000) >> 24);
                                byArray4[n39++] = (byte)((n52 & 0xFF0000) >> 16);
                                byArray4[n39++] = (byte)((n52 & 0xFF00) >> 8);
                                byArray4[n39++] = (byte)(n52 & 0xFF);
                            }
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n3 * 4);
                            continue block54;
                        }
                        if (n18 == 32773) {
                            n39 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n37++] = n39;
                            this.output.write(byArray3, 0, n39);
                            continue block54;
                        }
                        if (n18 != 32946) continue block54;
                        n39 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n37++] = n39;
                        this.output.write(byArray3, 0, n39);
                    }
                }
            }
        }
        if (n18 == 1) {
            if (bl4) {
                this.output.write(0);
            }
        } else {
            n5 = 0;
            for (n4 = 1; n4 < n15; ++n4) {
                n3 = (int)lArray[n4 - 1];
                n5 += n3;
                lArray2[n4] = lArray2[n4 - 1] + (long)n3;
            }
            int n53 = n33 = bl ? 0 : n + n32 + (n5 += (int)lArray[n15 - 1]);
            if ((n33 & 1) != 0) {
                ++n33;
                bl4 = true;
            }
            if (object == null) {
                if (bl4) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l7 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n33);
                seekableOutputStream.seek(l7);
            } else if (file != null) {
                int n54;
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output.close();
                this.output = object;
                this.writeDirectory(n, treeSet, n33);
                byte[] byArray7 = new byte[8192];
                for (n2 = 0; n2 < n5 && (n54 = fileInputStream.read(byArray7)) != -1; n2 += n54) {
                    this.output.write(byArray7, 0, n54);
                }
                fileInputStream.close();
                file.delete();
                if (bl4) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n, treeSet, n33);
                byteArrayOutputStream.writeTo(this.output);
                if (bl4) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n33;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n3 = tIFFField.getCount() * sizeOfType[tIFFField.getType()];
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeValues((TIFFField)arrayList.get(i));
        }
    }

    private static final int getValueSize(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = tIFFField.getAsString(i).getBytes();
                n3 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n3;
            }
        } else {
            n3 = n2 * sizeOfType[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                int n3;
                byte[] byArray = tIFFField.getAsBytes();
                if (n2 > 4) {
                    n2 = 4;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    this.output.write(byArray[n3]);
                }
                for (n3 = 0; n3 < 4 - n2; ++n3) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n4;
                char[] cArray = tIFFField.getAsChars();
                if (n2 > 2) {
                    n2 = 2;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    this.writeUnsignedShort(cArray[n4]);
                }
                for (n4 = 0; n4 < 2 - n2; ++n4) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i = 0; i < n2; ++i) {
                    this.output.write(byArray[i]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(cArray[i]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(sArray[i]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i = 0; i < n2; ++i) {
                    int n3 = Float.floatToIntBits(fArray[i]);
                    this.writeLong(n3);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i = 0; i < n2; ++i) {
                    long l = Double.doubleToLongBits(dArray[i]);
                    this.writeLong(l >>> 32);
                    this.writeLong(l & 0xFFFFFFFFFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i][0]);
                    this.writeLong(lArray[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray = tIFFField.getAsString(i).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder10");
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        this.output.write((n & 0xFF00) >>> 8);
        this.output.write(n & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)l & 0xFF);
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, n2, byArray2, n4);
            n3 += n2;
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6;
            byte by = byArray[n];
            for (n6 = 1; n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]; ++n6, ++n) {
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2]); ++n6) {
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }

    private static void modifyEncodeParam(JPEGEncodeParam jPEGEncodeParam, JPEGEncodeParam jPEGEncodeParam2, int n) {
        jPEGEncodeParam2.setDensityUnit(jPEGEncodeParam.getDensityUnit());
        jPEGEncodeParam2.setXDensity(jPEGEncodeParam.getXDensity());
        jPEGEncodeParam2.setYDensity(jPEGEncodeParam.getYDensity());
        jPEGEncodeParam2.setRestartInterval(jPEGEncodeParam.getRestartInterval());
        for (int i = 0; i < 4; ++i) {
            JPEGQTable jPEGQTable = jPEGEncodeParam.getQTable(i);
            if (jPEGQTable == null) continue;
            jPEGEncodeParam2.setQTable(i, jPEGQTable);
        }
    }
}

