/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;

public class FontFamilyResolver {
    public static final AWTFontFamily defaultFont;
    protected static final Map fonts;
    protected static final Vector awtFontFamilies;
    protected static final Vector awtFonts;
    protected static Map resolvedFontFamilies;

    public static String lookup(String string) {
        return (String)fonts.get(string.toLowerCase());
    }

    public static GVTFontFamily resolve(String string) {
        GVTFontFamily gVTFontFamily;
        if (resolvedFontFamilies == null) {
            resolvedFontFamilies = new HashMap();
        }
        if ((gVTFontFamily = (GVTFontFamily)resolvedFontFamilies.get(string.toLowerCase())) == null) {
            String string2 = (String)fonts.get(string.toLowerCase());
            if (string2 != null) {
                gVTFontFamily = new AWTFontFamily(string2);
            }
            resolvedFontFamilies.put(string.toLowerCase(), gVTFontFamily);
        }
        return gVTFontFamily;
    }

    public static GVTFontFamily resolve(UnresolvedFontFamily unresolvedFontFamily) {
        return FontFamilyResolver.resolve(unresolvedFontFamily.getFamilyName());
    }

    public static GVTFontFamily getFamilyThatCanDisplay(char c) {
        for (int i = 0; i < awtFontFamilies.size(); ++i) {
            AWTFontFamily aWTFontFamily = (AWTFontFamily)awtFontFamilies.get(i);
            AWTGVTFont aWTGVTFont = (AWTGVTFont)awtFonts.get(i);
            if (!aWTGVTFont.canDisplay(c) || aWTFontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return aWTFontFamily;
        }
        return null;
    }

    static {
        Object object;
        String string;
        Object object2;
        defaultFont = new AWTFontFamily("SansSerif");
        fonts = new HashMap();
        awtFontFamilies = new Vector();
        awtFonts = new Vector();
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            fonts.put(stringArray[i].toLowerCase(), stringArray[i]);
            object2 = new StringTokenizer(stringArray[i]);
            string = "";
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string = string + ((StringTokenizer)object2).nextToken();
            }
            fonts.put(string.toLowerCase(), stringArray[i]);
            object = stringArray[i].replace(' ', '-');
            if (((String)object).equals(stringArray[i])) continue;
            fonts.put(((String)object).toLowerCase(), stringArray[i]);
        }
        awtFontFamilies.add(defaultFont);
        awtFonts.add(new AWTGVTFont(defaultFont.getFamilyName(), 0, 12));
        Collection collection = fonts.values();
        object2 = collection.iterator();
        while (object2.hasNext()) {
            string = (String)object2.next();
            object = new AWTFontFamily(string);
            awtFontFamilies.add(object);
            AWTGVTFont aWTGVTFont = new AWTGVTFont(string, 0, 12);
            awtFonts.add(aWTGVTFont);
        }
    }
}

