/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileCountLimitExceededException;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormModelUpdateListener;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.JavaScriptReservedNames;
import org.apache.wicket.markup.html.form.validation.FormValidatorAdapter;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.parameter.EmptyRequestParameters;
import org.apache.wicket.util.encoding.UrlDecoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.value.LongValue;
import org.apache.wicket.util.visit.ClassVisitFilter;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitFilter;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Form<T>
extends WebMarkupContainer
implements IRequestListener,
IGenericComponent<T, Form<T>> {
    public static final String ENCTYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String HIDDEN_FIELDS_CSS_CLASS_KEY = CssUtils.key(Form.class, "hidden-fields");
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static final short FLAG_SUBMITTED = 256;
    private static final Logger log = LoggerFactory.getLogger(Form.class);
    private static final long serialVersionUID = 1L;
    public static final String UPLOAD_FAILED_RESOURCE_KEY = "uploadFailed";
    public static final String UPLOAD_TOO_LARGE_RESOURCE_KEY = "uploadTooLarge";
    public static final String UPLOAD_SINGLE_FILE_TOO_LARGE_RESOURCE_KEY = "uploadSingleFileTooLarge";
    public static final String UPLOAD_TOO_MANY_FILES_RESOURCE_KEY = "uploadTooManyFiles";
    private IFormSubmittingComponent defaultSubmittingComponent;
    private Bytes maxSize = null;
    private Bytes fileMaxSize;
    private long fileCountMax = -1L;
    private short multiPart = 0;
    private static final short MULTIPART_HARD = 1;
    private static final short MULTIPART_HINT_YES = 2;
    private static final short MULTIPART_HINT_NO = 4;
    private static final int HIDDEN_FIELDS_PARAMS_IDX = 0;
    private static final int HIDDEN_FIELDS_SUBMIT_IDX = 1;

    public Form(String id) {
        this(id, (IModel<T>)null);
    }

    public Form(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public void add(IFormValidator validator) {
        Args.notNull((Object)validator, (String)"validator");
        if (validator instanceof Behavior) {
            this.add((Behavior)((Object)validator));
        } else {
            this.add(new FormValidatorAdapter(validator));
        }
    }

    public void remove(IFormValidator validator) {
        Args.notNull((Object)validator, (String)"validator");
        Behavior match = null;
        for (Behavior behavior : this.getBehaviors()) {
            if (behavior.equals(validator)) {
                match = behavior;
                break;
            }
            if (!(behavior instanceof FormValidatorAdapter) || !((FormValidatorAdapter)behavior).getValidator().equals(validator)) continue;
            match = behavior;
            break;
        }
        if (match == null) {
            throw new IllegalStateException("Tried to remove form validator that was not previously added. Make sure your validator's equals() implementation is sufficient");
        }
        this.remove(match);
    }

    public final void clearInput() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.clearInput();
                }
            }
        });
    }

    public final void error(String error, Map<String, Object> args) {
        this.error((Serializable)((Object)new MapVariableInterpolator(error, args).toString()));
    }

    public final IFormSubmittingComponent findSubmitter() {
        final IRequestParameters parameters = Form.getRequestParameters(this);
        IFormSubmittingComponent submittingComponent = this.getPage().visitChildren(IFormSubmittingComponent.class, new IVisitor<Component, IFormSubmittingComponent>(){

            public void component(Component component, IVisit<IFormSubmittingComponent> visit) {
                String name;
                IFormSubmittingComponent submittingComponent = (IFormSubmittingComponent)((Object)component);
                Form<?> form = submittingComponent.getForm();
                if (!(form == null || form.getRootForm() != Form.this || parameters.getParameterValue(name = submittingComponent.getInputName()).isNull() && parameters.getParameterValue(name + ".x").isNull())) {
                    visit.stop((Object)submittingComponent);
                }
            }
        });
        return submittingComponent;
    }

    public final IFormSubmittingComponent getDefaultButton() {
        if (this.isRootForm()) {
            return this.defaultSubmittingComponent;
        }
        return this.getRootForm().getDefaultButton();
    }

    public final Collection<IFormValidator> getFormValidators() {
        ArrayList<IFormValidator> validators = new ArrayList<IFormValidator>();
        for (Behavior behavior : this.getBehaviors()) {
            if (!(behavior instanceof IFormValidator)) continue;
            validators.add((IFormValidator)((Object)behavior));
        }
        return Collections.unmodifiableCollection(validators);
    }

    public final CharSequence getJsForListenerUrl(CharSequence url) {
        Form<?> root = this.getRootForm();
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        String action = url.toString();
        if (root.encodeUrlInHiddenFields()) {
            buffer.append(String.format("document.getElementById('%s').innerHTML = '", root.getHiddenFieldsId(0)));
            int i = action.indexOf(63);
            if (i != -1) {
                this.writeParamsAsHiddenFields(Strings.split((String)action.substring(i + 1), (char)'&'), buffer);
                action = action.substring(0, i);
            }
            buffer.append("';");
        }
        buffer.append(String.format("var f = document.getElementById('%s');", root.getMarkupId()));
        buffer.append(String.format("f.action='%s';", action));
        buffer.append("Wicket.Event.fire(f, 'submit');");
        return buffer;
    }

    public final CharSequence getJsForSubmitter(IFormSubmittingComponent submitter, boolean triggerEvent) {
        Form<?> root = this.getRootForm();
        String param = submitter.getInputName() + "=x";
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append(String.format("var f = document.getElementById('%s');", root.getMarkupId()));
        buffer.append(String.format("document.getElementById('%s').innerHTML += '", root.getHiddenFieldsId(0)));
        this.writeParamsAsHiddenFields(new String[]{param}, buffer);
        buffer.append("';");
        if (triggerEvent) {
            buffer.append("Wicket.Event.requestSubmit(f);");
        } else {
            buffer.append("f.submit();");
        }
        return buffer;
    }

    public final Bytes getMaxSize() {
        final Bytes[] maxSize = new Bytes[]{this.maxSize};
        if (maxSize[0] == null) {
            this.visitChildren(Form.class, new IVisitor<Form<?>, Bytes>(){

                public void component(Form<?> component, IVisit<Bytes> visit) {
                    maxSize[0] = (Bytes)LongValue.maxNullSafe((LongValue)maxSize[0], (LongValue)component.maxSize);
                }
            });
        }
        if (maxSize[0] == null) {
            return this.getApplication().getApplicationSettings().getDefaultMaximumUploadSize();
        }
        return maxSize[0];
    }

    public Bytes getFileMaxSize() {
        return this.fileMaxSize;
    }

    public long getFileCountMax() {
        return this.fileCountMax;
    }

    public Form<?> getRootForm() {
        Form form;
        Form parent = this;
        while ((parent = (form = parent).findParent(Form.class)) != null) {
        }
        return form;
    }

    public String getValidatorKeyPrefix() {
        return null;
    }

    public final boolean hasError() {
        if (this.hasErrorMessage()) {
            return true;
        }
        return this.anyFormComponentError();
    }

    public boolean isRootForm() {
        return this.findParent(Form.class) == null;
    }

    public final boolean isSubmitted() {
        return this.getFlag(256);
    }

    @Override
    public final void onRequest() {
        this.onFormSubmitted(null);
    }

    protected MethodMismatchResponse onMethodMismatch() {
        return MethodMismatchResponse.CONTINUE;
    }

    public final void onFormSubmitted(IFormSubmitter submitter) {
        if (this.getRequest().getContainerRequest() instanceof HttpServletRequest) {
            String desiredMethod = this.getMethod();
            String actualMethod = ((HttpServletRequest)this.getRequest().getContainerRequest()).getMethod();
            if (!actualMethod.equalsIgnoreCase(desiredMethod)) {
                MethodMismatchResponse response = this.onMethodMismatch();
                switch (response) {
                    case ABORT: {
                        return;
                    }
                    case CONTINUE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid " + MethodMismatchResponse.class.getName() + " value: " + response);
                    }
                }
            }
        }
        this.markFormsSubmitted(submitter);
        if (this.handleMultiPart()) {
            this.inputChanged();
            if (submitter == null && (submitter = this.findSubmitter()) instanceof IFormSubmittingComponent) {
                IFormSubmittingComponent submittingComponent = (IFormSubmittingComponent)submitter;
                Component component = (Component)((Object)submitter);
                if (!component.isVisibleInHierarchy()) {
                    throw new WicketRuntimeException("Submit Button " + submittingComponent.getInputName() + " (path=" + component.getPageRelativePath() + ") is not visible");
                }
                if (!component.isEnabledInHierarchy()) {
                    throw new WicketRuntimeException("Submit Button " + submittingComponent.getInputName() + " (path=" + component.getPageRelativePath() + ") is not enabled");
                }
            }
            if (submitter != null && !submitter.getDefaultFormProcessing()) {
                submitter.onSubmit();
                submitter.onAfterSubmit();
            } else {
                Form<?> formToProcess = this.findFormToProcess(submitter);
                formToProcess.process(submitter);
            }
        } else if (this.hasError()) {
            this.callOnError(submitter);
        }
        this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> this.visitChildren(FormComponent.class, new IVisitor<FormComponent<?>, Void>((AjaxRequestTarget)target){
            final /* synthetic */ AjaxRequestTarget val$target;
            {
                this.val$target = ajaxRequestTarget;
            }

            public void component(FormComponent<?> component, IVisit<Void> visit) {
                component.updateAutoLabels(this.val$target, false);
            }
        }));
    }

    private Form<?> findFormToProcess(IFormSubmitter submitter) {
        if (submitter == null) {
            return this;
        }
        Form targetedForm = submitter.getForm();
        if (targetedForm == null) {
            throw new IllegalStateException("submitting component must not return 'null' on getForm()");
        }
        Form<?> rootForm = this.getRootForm();
        if (targetedForm == rootForm) {
            return rootForm;
        }
        Form formThatWantsToBeSubmitted = targetedForm;
        for (Form current = targetedForm.findParent(Form.class); current != null; current = current.findParent(Form.class)) {
            if (!current.wantSubmitOnNestedFormSubmit()) continue;
            formThatWantsToBeSubmitted = current;
        }
        return formThatWantsToBeSubmitted;
    }

    protected boolean wantSubmitOnNestedFormSubmit() {
        return false;
    }

    protected boolean wantSubmitOnParentFormSubmit() {
        return true;
    }

    public void process(IFormSubmitter submittingComponent) {
        if (!this.isEnabledInHierarchy() || !this.isVisibleInHierarchy()) {
            return;
        }
        this.validate();
        if (this.hasError()) {
            this.markFormComponentsInvalid();
            this.callOnError(submittingComponent);
        } else {
            this.markFormComponentsValid();
            this.beforeUpdateFormComponentModels();
            this.updateFormComponentModels();
            this.internalOnValidateModelObjects();
            if (this.hasError()) {
                this.callOnError(submittingComponent);
                return;
            }
            this.delegateSubmit(submittingComponent);
        }
    }

    protected void callOnError(IFormSubmitter submitter) {
        Form<?> processingForm = this.findFormToProcess(submitter);
        if (submitter != null) {
            submitter.onError();
        }
        Visits.visitPostOrder(processingForm, (IVisitor)new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (!form.isEnabledInHierarchy() || !form.isVisibleInHierarchy()) {
                    visit.dontGoDeeper();
                    return;
                }
                if (form.hasError()) {
                    form.onError();
                }
            }
        }, (IVisitFilter)new ClassVisitFilter(Form.class));
    }

    private void markFormsSubmitted(IFormSubmitter submitter) {
        this.setFlag(256, true);
        final Form<?> formToProcess = this.findFormToProcess(submitter);
        this.visitChildren(Form.class, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                Form form = (Form)component;
                if ((form.wantSubmitOnParentFormSubmit() || form == formToProcess) && form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    form.setFlag(256, true);
                    return;
                }
                visit.dontGoDeeper();
            }
        });
    }

    public final void setDefaultButton(IFormSubmittingComponent submittingComponent) {
        if (this.isRootForm()) {
            this.defaultSubmittingComponent = submittingComponent;
        } else {
            this.getRootForm().setDefaultButton(submittingComponent);
        }
    }

    public void setMaxSize(Bytes maxSize) {
        this.maxSize = maxSize;
    }

    public void setFileMaxSize(Bytes fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    public void setFileCountMax(long fileCountMax) {
        this.fileCountMax = fileCountMax;
    }

    public void setMultiPart(boolean multiPart) {
        this.multiPart = multiPart ? (short)(this.multiPart | 1) : (short)(this.multiPart & 0xFFFFFFFE);
    }

    @Override
    public final Component setVersioned(final boolean isVersioned) {
        super.setVersioned(isVersioned);
        this.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                formComponent.setVersioned(isVersioned);
            }
        });
        return this;
    }

    public final <R> R visitFormComponents(IVisitor<FormComponent<?>, R> visitor) {
        return this.visitChildren(FormComponent.class, visitor);
    }

    public final <R> R visitFormComponentsPostOrder(IVisitor<? extends FormComponent<?>, R> visitor) {
        return FormComponent.visitFormComponentsPostOrder(this, visitor);
    }

    private boolean anyFormComponentError() {
        Boolean error = this.visitChildren(Component.class, new IVisitor<Component, Boolean>(){

            public void component(Component component, IVisit<Boolean> visit) {
                if (component.hasErrorMessage() && component.isVisibleInHierarchy() && component.isEnabledInHierarchy()) {
                    visit.stop((Object)true);
                }
            }
        });
        return error != null && error != false;
    }

    private void inputChanged() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                formComponent.inputChanged();
            }
        });
    }

    protected void appendDefaultButtonField() {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append(String.format("<div hidden=\"\" class=\"%s\">", this.getString(HIDDEN_FIELDS_CSS_CLASS_KEY)));
        buffer.append("<input type=\"text\" tabindex=\"-1\" autocomplete=\"off\"/>");
        buffer.append(String.format("<input id=\"%s\" type=\"submit\" tabindex=\"-1\" name=\"%s\" />", this.getHiddenFieldsId(1), this.defaultSubmittingComponent.getInputName()));
        buffer.append("</div>");
        this.getResponse().write((CharSequence)buffer);
    }

    protected void addDefaultSubmitButtonHandler(IHeaderResponse headerResponse) {
        Component submittingComponent = (Component)((Object)this.defaultSubmittingComponent);
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append("var b=document.getElementById('");
        buffer.append(submittingComponent.getMarkupId());
        buffer.append("'); if (b!=null && b.onclick!=null && typeof(b.onclick) != 'undefined') ");
        buffer.append("{  var r = Wicket.bind(b.onclick, b)(); if (r != false) b.click(); } else { b.click(); };  return false;");
        headerResponse.render(OnEventHeaderItem.forMarkupId(this.getHiddenFieldsId(1), "click", buffer.toString()));
    }

    protected void beforeUpdateFormComponentModels() {
    }

    protected void delegateSubmit(IFormSubmitter submittingComponent) {
        Form<?> processingForm = this.findFormToProcess(submittingComponent);
        final ArrayList forms = Generics.newArrayList((int)3);
        Visits.visitPostOrder(processingForm, (IVisitor)new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form.isSubmitted()) {
                    forms.add(form);
                }
            }
        }, (IVisitFilter)new ClassVisitFilter(Form.class));
        if (submittingComponent != null) {
            submittingComponent.onSubmit();
        }
        for (Form form : forms) {
            form.onSubmit();
        }
        if (submittingComponent != null) {
            submittingComponent.onAfterSubmit();
        }
    }

    private final String getHiddenFieldsId(int idx) {
        return this.getInputNamePrefix() + this.getMarkupId() + "_hf_" + idx;
    }

    protected String getMethod() {
        String method = this.getMarkupAttributes().getString("method");
        return method != null ? method : METHOD_POST;
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }

    public boolean isMultiPart() {
        if (this.multiPart == 0) {
            Boolean anyEmbeddedMultipart = this.visitChildren(Component.class, new IVisitor<Component, Boolean>(){

                public void component(Component component, IVisit<Boolean> visit) {
                    FormComponent fc;
                    boolean isMultiPart = false;
                    if (component instanceof Form) {
                        Form form = (Form)component;
                        if (form.isVisibleInHierarchy() && form.isEnabledInHierarchy()) {
                            isMultiPart = (form.multiPart & 1) != 0;
                        }
                    } else if (component instanceof FormComponent && (fc = (FormComponent)component).isVisibleInHierarchy() && fc.isEnabledInHierarchy()) {
                        isMultiPart = fc.isMultiPart();
                    }
                    if (isMultiPart) {
                        visit.stop((Object)true);
                    }
                }
            });
            this.multiPart = Boolean.TRUE.equals(anyEmbeddedMultipart) ? (short)(this.multiPart | 2) : (short)(this.multiPart | 4);
        }
        return (this.multiPart & 3) != 0;
    }

    protected boolean handleMultiPart() {
        if (this.isMultiPart()) {
            try {
                ServletWebRequest request = (ServletWebRequest)this.getRequest();
                MultipartServletWebRequest multipartWebRequest = request.newMultipartWebRequest(this.getMaxSize(), this.getPage().getId());
                multipartWebRequest.setFileMaxSize(this.getFileMaxSize());
                multipartWebRequest.setFileCountMax(this.getFileCountMax());
                multipartWebRequest.parseFileParts();
                this.getRequestCycle().setRequest((Request)multipartWebRequest);
            }
            catch (FileUploadException fux) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("exception", (Object)fux);
                model.put("maxSize", this.getMaxSize());
                model.put("fileMaxSize", this.getFileMaxSize());
                model.put("fileCountMax", this.getFileCountMax());
                this.onFileUploadException(fux, model);
                return false;
            }
        }
        return true;
    }

    protected void onFileUploadException(FileUploadException e, Map<String, Object> model) {
        if (e instanceof FileUploadBase.SizeLimitExceededException) {
            String msg = this.getString(UPLOAD_TOO_LARGE_RESOURCE_KEY, Model.ofMap(model));
            this.error((Serializable)((Object)msg));
        } else if (e instanceof FileUploadBase.FileSizeLimitExceededException) {
            String msg = this.getString(UPLOAD_SINGLE_FILE_TOO_LARGE_RESOURCE_KEY, Model.ofMap(model));
            this.error((Serializable)((Object)msg));
        } else if (e instanceof FileCountLimitExceededException) {
            String msg = this.getString(UPLOAD_TOO_MANY_FILES_RESOURCE_KEY, Model.ofMap(model));
            this.error((Serializable)((Object)msg));
        } else {
            String msg = this.getString(UPLOAD_FAILED_RESOURCE_KEY, Model.ofMap(model));
            this.error((Serializable)((Object)msg));
            log.warn(msg, (Throwable)e);
        }
    }

    @Override
    protected void internalOnModelChanged() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.sameInnermostModel(Form.this)) {
                    formComponent.modelChanged();
                }
            }
        });
    }

    protected final void markFormComponentsInvalid() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.invalid();
                }
            }
        });
    }

    protected final void markFormComponentsValid() {
        this.internalMarkFormComponentsValid();
        this.markNestedFormComponentsValid();
    }

    private void markNestedFormComponentsValid() {
        this.visitChildren(Form.class, new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form.isSubmitted()) {
                    form.internalMarkFormComponentsValid();
                } else {
                    visit.dontGoDeeper();
                }
            }
        });
    }

    private void internalMarkFormComponentsValid() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.getForm() == Form.this && formComponent.isVisibleInHierarchy()) {
                    formComponent.valid();
                }
            }
        });
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isRootForm()) {
            this.checkComponentTag(tag, "form");
            String method = this.getMethod().toLowerCase(Locale.ROOT);
            tag.put("method", method);
            String url = this.getActionUrl().toString();
            if (this.encodeUrlInHiddenFields()) {
                int i = url.indexOf(63);
                String action = i > -1 ? url.substring(0, i) : "";
                tag.put("action", action);
            } else {
                tag.put("action", url);
            }
            if (this.isMultiPart()) {
                if (METHOD_GET.equalsIgnoreCase(method)) {
                    log.warn("Form with id '{}' is multipart. It should use method 'POST'!", (Object)this.getId());
                    tag.put("method", METHOD_POST.toLowerCase(Locale.ROOT));
                }
                tag.put("enctype", ENCTYPE_MULTIPART_FORM_DATA);
                tag.put("accept-charset", this.getApplication().getRequestCycleSettings().getResponseRequestEncoding());
            } else {
                String enctype = (String)tag.getAttributes().get((Object)"enctype");
                if (ENCTYPE_MULTIPART_FORM_DATA.equalsIgnoreCase(enctype)) {
                    this.setMultiPart(true);
                }
            }
        } else {
            this.adjustNestedTagName(tag);
            tag.remove("method");
            tag.remove("action");
            tag.remove("enctype");
        }
    }

    private void adjustNestedTagName(ComponentTag tag) {
        if ("form".equalsIgnoreCase(tag.getName())) {
            tag.setName("div");
        }
    }

    protected CharSequence getActionUrl() {
        return this.urlForListener(new PageParameters());
    }

    @Override
    protected void renderPlaceholderTag(ComponentTag tag, Response response) {
        if (!this.isRootForm()) {
            this.adjustNestedTagName(tag);
        }
        super.renderPlaceholderTag(tag, response);
    }

    protected boolean encodeUrlInHiddenFields() {
        return METHOD_GET.equalsIgnoreCase(this.getMethod());
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.isRootForm()) {
            this.writeHiddenFields();
        }
        super.onComponentTagBody(markupStream, openTag);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.hasDefaultSubmittingComponent()) {
            this.addDefaultSubmitButtonHandler(response);
        }
    }

    public final void writeHiddenFields() {
        this.getResponse().write((CharSequence)String.format("<div id=\"%s\" hidden=\"\" class=\"%s\">", this.getHiddenFieldsId(0), this.getString(HIDDEN_FIELDS_CSS_CLASS_KEY)));
        if (this.encodeUrlInHiddenFields()) {
            AppendingStringBuffer buffer = new AppendingStringBuffer();
            String url = this.getActionUrl().toString();
            int i = url.indexOf(63);
            String queryString = i > -1 ? url.substring(i + 1) : url;
            String[] params = Strings.split((String)queryString, (char)'&');
            this.writeParamsAsHiddenFields(params, buffer);
            this.getResponse().write((CharSequence)buffer);
        }
        this.getResponse().write((CharSequence)"</div>");
        if (this.hasDefaultSubmittingComponent()) {
            this.appendDefaultButtonField();
        }
    }

    private boolean hasDefaultSubmittingComponent() {
        if (this.defaultSubmittingComponent instanceof Component) {
            Component submittingComponent = (Component)((Object)this.defaultSubmittingComponent);
            return submittingComponent.isVisibleInHierarchy() && submittingComponent.isEnabledInHierarchy();
        }
        return false;
    }

    protected void writeParamsAsHiddenFields(String[] params, AppendingStringBuffer buffer) {
        for (String param : params) {
            String[] pair = Strings.split((String)param, (char)'=');
            buffer.append("<input type=\"hidden\" name=\"").append(this.recode(pair[0])).append("\" value=\"").append(pair.length > 1 ? this.recode(pair[1]) : "").append("\" />");
        }
    }

    private String recode(String s) {
        String un = UrlDecoder.QUERY_INSTANCE.decode(s, this.getRequest().getCharset());
        return Strings.escapeMarkup((CharSequence)un).toString();
    }

    @Override
    protected void onDetach() {
        this.setFlag(256, false);
        super.onDetach();
    }

    protected void onError() {
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AjaxRequestTarget) {
            this.multiPart = (short)(this.multiPart & 1);
        }
    }

    @Override
    protected void onBeforeRender() {
        this.multiPart = (short)(this.multiPart & 1);
        super.onBeforeRender();
    }

    protected void onSubmit() {
    }

    protected final void updateFormComponentModels() {
        this.internalUpdateFormComponentModels();
        this.updateNestedFormComponentModels();
    }

    private void updateNestedFormComponentModels() {
        this.visitChildren(Form.class, new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form.isSubmitted()) {
                    form.internalUpdateFormComponentModels();
                } else {
                    visit.dontGoDeeper();
                }
            }
        });
    }

    private void internalUpdateFormComponentModels() {
        FormComponent.visitComponentsPostOrder(this, new FormModelUpdateVisitor(this));
    }

    protected final void validate() {
        if (this.isEnabledInHierarchy() && this.isVisibleInHierarchy()) {
            this.validateNestedForms();
            this.validateComponents();
            this.validateFormValidators();
            this.onValidate();
        }
    }

    protected void onValidate() {
    }

    private void internalOnValidateModelObjects() {
        this.onValidateModelObjects();
        this.visitChildren(Form.class, new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form.isSubmitted()) {
                    form.onValidateModelObjects();
                } else {
                    visit.dontGoDeeper();
                }
            }
        });
    }

    protected void onValidateModelObjects() {
    }

    protected final void validateComponents() {
        this.visitFormComponentsPostOrder(new ValidationVisitor(){

            @Override
            public void validate(FormComponent<?> formComponent) {
                Form<?> form = formComponent.getForm();
                if (form == Form.this && form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    formComponent.validate();
                }
            }
        });
    }

    private boolean isFormComponentVisibleInPage(FormComponent<?> fc) {
        if (fc == null) {
            throw new IllegalArgumentException("Argument `fc` cannot be null");
        }
        return fc.isVisibleInHierarchy();
    }

    protected final void validateFormValidator(IFormValidator validator) {
        Args.notNull((Object)validator, (String)"validator");
        FormComponent<?>[] dependents = validator.getDependentFormComponents();
        boolean validate = true;
        if (dependents != null) {
            for (FormComponent<?> dependent : dependents) {
                if (!dependent.isValid()) {
                    validate = false;
                    break;
                }
                if (this.isFormComponentVisibleInPage(dependent)) continue;
                if (log.isWarnEnabled()) {
                    log.warn("IFormValidator in form `" + this.getPageRelativePath() + "` depends on a component that has been removed from the page or is no longer visible. Offending component id `" + dependent.getId() + "`.");
                }
                validate = false;
                break;
            }
        }
        if (validate) {
            validator.validate(this);
        }
    }

    protected final void validateFormValidators() {
        for (Behavior behavior : this.getBehaviors()) {
            if (!(behavior instanceof IFormValidator)) continue;
            this.validateFormValidator((IFormValidator)((Object)behavior));
        }
    }

    private void validateNestedForms() {
        Visits.visitPostOrder((Object)this, (IVisitor)new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form == Form.this) {
                    visit.stop();
                    return;
                }
                if (form.isSubmitted()) {
                    form.validateComponents();
                    form.validateFormValidators();
                    form.onValidate();
                }
            }
        }, (IVisitFilter)new ClassVisitFilter(Form.class));
    }

    protected String getInputNamePrefix() {
        return "";
    }

    public static Form<?> findForm(Component component) {
        return component.findParent(Form.class);
    }

    public static String getRootFormRelativeId(Component component) {
        String id = component.getId();
        PrependingStringBuffer inputName = new PrependingStringBuffer(id.length());
        Component c = component;
        while (true) {
            inputName.prepend(id);
            c = c.getParent();
            if (c == null || c instanceof Form && ((Form)c).isRootForm() || c instanceof Page) break;
            inputName.prepend(':');
            id = c.getId();
        }
        if (JavaScriptReservedNames.isNameReserved(inputName.toString())) {
            inputName.prepend(':');
            inputName.prepend(':');
            inputName.prepend("p");
        }
        return inputName.toString();
    }

    static IRequestParameters getRequestParameters(Component component) {
        EmptyRequestParameters parameters;
        String method = METHOD_POST;
        Request request = component.getRequest();
        if (request.getContainerRequest() instanceof HttpServletRequest) {
            method = ((HttpServletRequest)request.getContainerRequest()).getMethod();
        } else {
            Form form = component instanceof Form ? (Form)component : component.findParent(Form.class);
            if (form != null) {
                method = form.getMethod();
            }
        }
        switch (method.toLowerCase(Locale.ROOT)) {
            case "post": {
                parameters = request.getPostParameters();
                break;
            }
            case "get": {
                parameters = request.getQueryParameters();
                break;
            }
            default: {
                parameters = EmptyRequestParameters.INSTANCE;
            }
        }
        return parameters;
    }

    public static enum MethodMismatchResponse {
        CONTINUE,
        ABORT;

    }

    private static class FormModelUpdateVisitor
    implements IVisitor<Component, Void> {
        private final Form<?> formFilter;

        public FormModelUpdateVisitor(Form<?> formFilter) {
            this.formFilter = formFilter;
        }

        public void component(Component component, IVisit<Void> visit) {
            Form<?> form;
            if (component instanceof IFormModelUpdateListener && (form = Form.findForm(component)) != null && (this.formFilter == null || this.formFilter == form) && form.isEnabledInHierarchy() && component.isVisibleInHierarchy() && component.isEnabledInHierarchy()) {
                ((IFormModelUpdateListener)((Object)component)).updateModel();
            }
        }
    }

    public static abstract class ValidationVisitor
    implements IVisitor<FormComponent<?>, Void> {
        public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
            Form<?> form = formComponent.getForm();
            if (!form.isVisibleInHierarchy() || !form.isEnabledInHierarchy()) {
                visit.dontGoDeeper();
                return;
            }
            if (formComponent.isVisibleInHierarchy() && formComponent.isEnabledInHierarchy()) {
                this.validate(formComponent);
            }
            if (!formComponent.processChildren()) {
                visit.dontGoDeeper();
            }
        }

        public abstract void validate(FormComponent<?> var1);
    }
}

