/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom.jaxp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private DocumentBuilderFactoryImpl factory;
    private final DOMMetaFactory domMetaFactory;

    protected DocumentBuilderImpl(DocumentBuilderFactoryImpl fac, DOMMetaFactory domMetaFactory) {
        this.factory = fac;
        this.domMetaFactory = domMetaFactory;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return true;
    }

    public DOMImplementation getDOMImplementation() {
        return this.domMetaFactory.getDOMImplementation();
    }

    public Document newDocument() {
        return (Document)((Object)this.domMetaFactory.getOMFactory().createOMDocument());
    }

    public void setEntityResolver(EntityResolver er) {
    }

    public void setErrorHandler(ErrorHandler eh) {
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        try {
            OMFactory factory = this.domMetaFactory.getOMFactory();
            XMLStreamReader reader = StAXUtils.createXMLStreamReader(inputSource.getCharacterStream());
            StAXOMBuilder builder = new StAXOMBuilder(factory, reader);
            OMDocument doc = builder.getDocument();
            doc.build();
            return (Document)((Object)doc);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        try {
            OMFactory factory = this.domMetaFactory.getOMFactory();
            XMLStreamReader reader = StAXUtils.createXMLStreamReader(is);
            StAXOMBuilder builder = new StAXOMBuilder(factory, reader);
            return (Document)((Object)builder.getDocument());
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public Document parse(File file) throws SAXException, IOException {
        try {
            OMFactory factory = this.domMetaFactory.getOMFactory();
            XMLStreamReader reader = StAXUtils.createXMLStreamReader(new FileInputStream(file));
            StAXOMBuilder builder = new StAXOMBuilder(factory, reader);
            return (Document)((Object)builder.getDocument());
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public Document parse(String uri) throws SAXException, IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public Schema getSchema() {
        return this.factory.schema;
    }
}

