var hdg = props.globals.getNode("orientation/heading-magnetic-deg");
var hdgBug = props.globals.getNode("autopilot/settings/heading-bug-deg");
var lon = props.globals.getNode("position/longitude-deg");
var lat = props.globals.getNode("position/latitude-deg");
var index = 0;
var scales = [2.5,5,12.5,25,50,100]; # zoom scales

var instrument_path = "Aircraft/Arcus/Models/Interior/Panel/Instruments/LX9050/";

var lx9050_controller = {
	parents: [canvas.Map.Controller],

	new: func(map) {
		var m = { parents: [lx9050_controller],
			map: map,
			};
		m.index = index;

		setlistener("instrumentation/LX9050/internal/trigger", func{
			m.map.setPos(lat.getValue(), lon.getValue(), hdg.getValue());
			m.map.update();
		});
		return m;
	}
};

var canvas_nd = {
	new: func(canvasGroup)
	{
		var m = { parents: [canvas_nd] };
		m.group = canvasGroup;
		m.map = canvasGroup.createChild('map');
		m.index = index;
		m.Tmp = 0;
		m.oldHeading = 0;
		m.range = 25;

		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		canvas.parsesvg(canvasGroup, instrument_path~"LX9050_main.svg", {'font-mapper': font_mapper});

		var svg_keys = ["time.text","north.needle","wind.needle","wind.text","netto.ms","thermal.ms","agl.m","alt.m","trk.degree","gs.kmh"];
		foreach(var key; svg_keys) {
			m[key] = canvasGroup.getElementById(key);
		}

		### NavDisplay ###
		m.map.setRange(25);
		m.map.setTranslation(242,427);
		m.map.setPos(lat.getValue(),lon.getValue(),hdg.getValue());
		var r = func(name,vis=1,zindex=nil) return caller(0)[0];
		foreach(var type; [ r('STAMEN') ]) {
				m.map.addLayer(factory: canvas.OverlayLayer, type_arg: type.name,
												 visible: type.vis, priority: type.zindex,
												  );
		}
		m.map.setController(lx9050_controller);
		index+=1;

		m.timer = maketimer(0.2, m, m.update);
		return m;
	},
	update: func()
	{
		# Top bar
		me["time.text"].setText(sprintf("%02d", time_hr.getValue()) ~ ":" ~ sprintf("%02d", time_min.getValue()));
		
		# Map part
		var nose_heading = hdg_true.getValue();
		me["north.needle"].setRotation(-nose_heading*D2R);
		var wind_hdg = wind_deg.getValue();
		me["wind.needle"].setRotation(-(nose_heading-wind_hdg)*D2R);
		me["wind.text"].setText(sprintf("%3d", math.round(wind_hdg)) ~ "/" ~ sprintf("%2d", math.round(wind_kt.getValue())));
		
		# Low part
		me["netto.ms"].setText(sprintf("%2.1f", vario_te.getValue()-0.5));	#TODO calculate netto vario value correct
		me["thermal.ms"].setText(sprintf("%2.1f", vario_av.getValue()));
		
		me["agl.m"].setText(sprintf("%4d", math.round(alt_agl.getValue()*FT2M)));
		me["alt.m"].setText(sprintf("%4d", math.round(alt_gps.getValue()*FT2M)));
		
		me["trk.degree"].setText(sprintf("%3d", math.round(hdg_trk.getValue())));
		
		me["gs.kmh"].setText(sprintf("%3d", math.round(gs_kt.getValue() * KT2MPS * 3.6 )));
		
		setprop("instrumentation/LX9050/internal/trigger", 1);
	},
	show: func()
	{
		me.update();
		me.timer.start();
		me.group.show();
	},
	hide: func()
	{
		me.timer.stop();
		me.group.hide();
	}
};
