###################################
## Override controls.* functions ##
###################################
var hydraulic_pressure = props.globals.getNode("fdm/jsbsim/systems/hydraulic/pressure-psi");
var gear_cmd = props.globals.getNode("fdm/jsbsim/gear/gear-cmd-norm");
var gear_control = props.globals.getNode("fdm/jsbsim/gear/gear-int-norm");
var gear_no_wow = props.globals.getNode("fdm/jsbsim/fcs/gear-no-wow");
setlistener( hydraulic_pressure, func() {
	if( hydraulic_pressure.getDoubleValue() > 2500 and gear_cmd.getBoolValue() != gear_control.getBoolValue() and gear_no_wow.getBoolValue() ){
		gear_control.setBoolValue( gear_cmd.getBoolValue() );
	}
});

var wow0 = props.globals.getNode("/gear/gear[0]/wow");
var nws_microswitch = props.globals.getNode("/fdm/jsbsim/fcs/nws-microswitch-wow");
setlistener( wow0, func() {
	if( !wow0.getBoolValue() and nws_microswitch.getBoolValue() ) {
		nws_microswitch.setBoolValue( 0 );
	} else if ( wow0.getBoolValue() and !nws_microswitch.getBoolValue() ) {
		settimer( func() { nws_microswitch.setBoolValue( wow0.getBoolValue() ) }, 0.5 );
	}
});

##############
## Liveries ##
##############
aircraft.livery.init("Aircraft/do228/Models/Liveries");


###############
## Autostart ##
###############
var autostart = func {
	setprop("/controls/electric/batt1", 1);
	setprop("/controls/electric/batt2", 1);
	setprop("/controls/electric/master", 1);
	start( 0 );
	settimer( func { 
		setprop("/controls/engines/engine[0]/engine-speed", 1.0);
		settimer( func {
			start( 1 );
			settimer( func {
				setprop("/controls/engines/engine[1]/engine-speed", 1.0);
			}, 2 );	
		}, 15 );
	}, 2 );
	setprop("/controls/electric/generator[0]", 1);
	setprop("/controls/electric/generator[1]", 1);
	#	Avionics
	setprop("/controls/electric/avionics", 1);
	setprop("/controls/electric/fds-ap", 1);
}

######################
## Gear Lever Light ##
######################
var gear_lever_light = aircraft.light.new("/gear/lever-light", [0.25, 0.25], "/fdm/jsbsim/fcs/gear-transit");
