// -*- mode: C; -*-
// Licence: GPL v2
// © Emilian Huminiuc and Vivian Meazza 2011
#version 120



// the file is directly copied from model-combined.eff except the (three) STICK CLOTH to END STICK CLOTH parts
// and the subsequent gl_Vertex integrations
// I didnt find how to do a more beautiful way (including model-combined and only adding the wingflexer part)
// if you know how to do this, please do :)

varying	vec3	rawpos;
varying	vec3	VNormal;
varying	vec3	VTangent;
varying	vec3	VBinormal;
varying	vec3	vViewVec;
varying	vec3	reflVec;
varying vec3 	vertVec;

varying	float	alpha;

attribute	vec3	tangent;
attribute	vec3	binormal;

uniform	float		pitch;
uniform	float		roll;
uniform	float		hdg;
uniform	int  		refl_dynamic;
uniform int  		nmap_enabled;
uniform int  		shader_qual;

// STICK CLOTH
uniform float		pitch_norm;
uniform float		roll_norm;
uniform float		pitch_factor;
uniform float		roll_factor;
uniform float		base_x_m;
uniform float		base_z_m;
uniform float		tip_x_m;
uniform float		tip_z_m;
uniform float		falloff_max_m;
// END STICK CLOTH

//////Fog Include///////////
// uniform	int 	fogType;
// void	fog_Func(int type);
////////////////////////////

void setupShadows(vec4 eyeSpacePos);

void	rotationMatrixPR(in float sinRx, in float cosRx, in float sinRy, in float cosRy, out mat4 rotmat)
{
	rotmat = mat4(	cosRy ,	sinRx * sinRy ,	cosRx * sinRy,	0.0,
									0.0   ,	cosRx        ,	-sinRx * cosRx,	0.0,
									-sinRy,	sinRx * cosRy,	cosRx * cosRy ,	0.0,
									0.0   ,	0.0          ,	0.0           ,	1.0 );
}

void	rotationMatrixH(in float sinRz, in float cosRz, out mat4 rotmat)
{
	rotmat = mat4(	cosRz,	-sinRz,	0.0,	0.0,
									sinRz,	cosRz,	0.0,	0.0,
									0.0  ,	0.0  ,	1.0,	0.0,
									0.0  ,	0.0  ,	0.0,	1.0 );
}

void	main(void)
{
		// STICK CLOTH
		vec4 vertex = gl_Vertex;
		
		float rotation_rad;
		float rot_x1;
		float rot_x2;
		float rot_y1;
		float rot_y2;
		float rot_z1;
		float rot_z2;
		float tip_dist_m;
		
		tip_dist_m = sqrt( pow( tip_x_m - vertex.x, 2 ) + pow( tip_z_m - vertex.z, 2 ) );
			
		// Two consecutive rotations (first pitch, then roll)
		for( int i = 0; i <= 1; ++i ){
		
		
			if( i == 0 ){
				rotation_rad = pitch_norm * pitch_factor * ( 1 - min( tip_dist_m / falloff_max_m, 1 ) );
				rot_x1 = base_x_m;
				rot_y1 = -1.0;
				rot_z1 = base_z_m;
				rot_x2 = base_x_m;
				rot_y2 = 1.0;
				rot_z2 = base_z_m;
			} else {
				rotation_rad = roll_norm * roll_factor * ( 1 - min( tip_dist_m / falloff_max_m, 1 ) );
				rot_x1 = -1.0;
				rot_y1 = 0.0;
				rot_z1 = base_z_m;
				rot_x2 = 1.0;
				rot_y2 = 0.0;
				rot_z2 = base_z_m;
			}
		
			//Calculate rotation
			vec3 normal;
			normal[0]=rot_x2-rot_x1;
			normal[1]=rot_y2-rot_y1;
			normal[2]=rot_z2-rot_z1;
			normal = normalize(normal);
			float tmp = (1-cos(rotation_rad));
			mat4 rotation_matrix = mat4(
				pow(normal[0],2)*tmp+cos(rotation_rad),			normal[1]*normal[0]*tmp-normal[2]*sin(rotation_rad),	normal[2]*normal[0]*tmp+normal[1]*sin(rotation_rad),	0.0,
				normal[0]*normal[1]*tmp+normal[2]*sin(rotation_rad),	pow(normal[1],2)*tmp+cos(rotation_rad),			normal[2]*normal[1]*tmp-normal[0]*sin(rotation_rad),	0.0,
				normal[0]*normal[2]*tmp-normal[1]*sin(rotation_rad),	normal[1]*normal[2]*tmp+normal[0]*sin(rotation_rad),	pow(normal[2],2)*tmp+cos(rotation_rad),			0.0,
				0.0,							0.0,							0.0,							1.0
				);
			vec4 old_point;
			old_point[0]=vertex.x;
			old_point[1]=vertex.y;
			old_point[2]=vertex.z;
			old_point[3]=1.0;
			rotation_matrix[3][0] = rot_x1 	- rot_x1*rotation_matrix[0][0] - rot_y1*rotation_matrix[1][0] - rot_z1*rotation_matrix[2][0];
			rotation_matrix[3][1] = rot_y1 	- rot_x1*rotation_matrix[0][1] - rot_y1*rotation_matrix[1][1] - rot_z1*rotation_matrix[2][1];
			rotation_matrix[3][2] = rot_z1 	- rot_x1*rotation_matrix[0][2] - rot_y1*rotation_matrix[1][2] - rot_z1*rotation_matrix[2][2];
			vec4 new_point=rotation_matrix*old_point;
			vertex.x=new_point[0];
			vertex.y=new_point[1];
			vertex.z=new_point[2];
		}
		// END STICK CLOTH

		rawpos = vertex.xyz;
		vec4 ecPosition = gl_ModelViewMatrix * vertex;
		//rawpos = gl_Vertex.xyz;
		//vec4 ecPosition = gl_ModelViewMatrix * gl_Vertex;
		//fog_Func(fogType);

		VNormal = normalize(gl_NormalMatrix * gl_Normal);

		vec3 n = normalize(gl_Normal);
		vec3 tempTangent = cross(n, vec3(1.0,0.0,0.0));
		vec3 tempBinormal = cross(n, tempTangent);

		if (nmap_enabled > 0){
			tempTangent = tangent;
			tempBinormal  = binormal;
		}

		VTangent = normalize(gl_NormalMatrix * tempTangent);
		VBinormal = normalize(gl_NormalMatrix * tempBinormal);
		vec3 t = tempTangent;
		vec3 b = tempBinormal;

    // Super hack: if diffuse material alpha is less than 1, assume a
	// transparency animation is at work
		if (gl_FrontMaterial.diffuse.a < 1.0)
			alpha = gl_FrontMaterial.diffuse.a;
		else
			alpha = gl_Color.a;

    // Vertex in eye coordinates
		vertVec = ecPosition.xyz;
		vViewVec.x = dot(t, vertVec);
		vViewVec.y = dot(b, vertVec);
		vViewVec.z = dot(n, vertVec);

    // calculate the reflection vector
		vec4 reflect_eye = vec4(reflect(vertVec, VNormal), 0.0);
		vec3 reflVec_stat = normalize(gl_ModelViewMatrixInverse * reflect_eye).xyz;
		if (refl_dynamic > 0){
			//prepare rotation matrix
			mat4 RotMatPR;
			mat4 RotMatH;
			float _roll = roll;
			if (_roll>90.0 || _roll < -90.0)
			{
				_roll = -_roll;
			}
			float cosRx = cos(radians(_roll));
			float sinRx = sin(radians(_roll));
			float cosRy = cos(radians(-pitch));
			float sinRy = sin(radians(-pitch));
			float cosRz = cos(radians(hdg));
			float sinRz = sin(radians(hdg));
			rotationMatrixPR(sinRx, cosRx, sinRy, cosRy, RotMatPR);
			rotationMatrixH(sinRz, cosRz, RotMatH);
			vec3 reflVec_dyn = (RotMatH * (RotMatPR * normalize(gl_ModelViewMatrixInverse * reflect_eye))).xyz;

			reflVec = reflVec_dyn;
		} else {
			reflVec = reflVec_stat;
		}


		gl_FrontColor = gl_FrontMaterial.emission + gl_Color
					  * (gl_LightModel.ambient + gl_LightSource[0].ambient);

		gl_Position = gl_ModelViewProjectionMatrix * vertex;
		//gl_Position = ftransform();
		gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;


        setupShadows(ecPosition);
}
