/*  This file is part of the KDE libraries
 *  Copyright 2014 Daniel Vrátil <dvratil@redhat.com>
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License or ( at
 *  your option ) version 3 or, at the discretion of KDE e.V. ( which shall
 *  act as a proxy as in section 14 of the GPLv3 ), any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "ktexttohtml.h"

#include <kemoticons.h>
#include <kemoticonstheme.h>

#include <QGlobalStatic>

Q_GLOBAL_STATIC(KEmoticonsTheme, sTheme);


KTextToHTMLEmoticons::KTextToHTMLEmoticons()
{
}

QString KTextToHTMLEmoticons::parseEmoticons(const QString &text,
                                             bool strictParse,
                                             const QStringList &exclude)
{
    KEmoticons emoticons;
    if (sTheme->themeName() != emoticons.currentThemeName()) {
        *sTheme = emoticons.theme();
    }

    KEmoticonsTheme::ParseMode mode = KEmoticonsTheme::DefaultParse;
    if (strictParse) {
        mode = KEmoticonsTheme::StrictParse;
    }
    return sTheme->parseEmoticons(text, mode, exclude);
}
