/*
    <one line to give the library's name and an idea of what it does.>
    Copyright (C) 2012  Vishesh Handa <me@vhanda.in>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef TAGLIBEXTRACTOR_H
#define TAGLIBEXTRACTOR_H

#include "extractorplugin.h"
#include <tstring.h>
#include <tstringlist.h>
#include <tfilestream.h>

namespace KFileMetaData
{

class TagLibExtractor : public ExtractorPlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.kde.kf5.kfilemetadata.ExtractorPlugin")
    Q_INTERFACES(KFileMetaData::ExtractorPlugin)

public:
    explicit TagLibExtractor(QObject* parent = nullptr);

    void extract(ExtractionResult* result) Q_DECL_OVERRIDE;
    QStringList mimetypes() const Q_DECL_OVERRIDE;
    
private:
    struct ExtractedData {
        TagLib::String artists;
        TagLib::String albumArtists;
        TagLib::String composers;
        TagLib::String lyricists;
        TagLib::StringList genres;
        QVariant discNumber;
    };
    void extractMP3(TagLib::FileStream& stream, ExtractedData& data);
    void extractMP4(TagLib::FileStream& stream, ExtractedData& data);
    void extractMusePack(TagLib::FileStream& stream, ExtractedData& data);
    void extractOgg(TagLib::FileStream& stream, const QString& mimetype, ExtractedData& data);
};

}

#endif // TAGLIBEXTRACTOR_H
