/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import vlcskineditor.FrameUpdater;
import vlcskineditor.Language;
import vlcskineditor.resources.Bitmap;
import vlcskineditor.resources.SubBitmap;

public class SubBitmapEditWindow
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
KeyListener,
WindowListener {
    public JFrame frame;
    JScrollPane scroll_pane;
    JPanel zoom_panel;
    JButton zoom_more;
    JButton zoom_less;
    JLabel zoom_label;
    int z_fact = 1;
    Bitmap b;
    SubBitmap sb;
    FrameUpdater fu;
    boolean starteddragging = false;
    int x1;
    int y1;
    int x2;
    int y2;
    int x1_org;
    int y1_org;
    int x2_org;
    int y2_org;
    int p_width;
    int p_height;
    int drawcount;

    public SubBitmapEditWindow(Bitmap bitmap, SubBitmap subBitmap) {
        this.b = bitmap;
        this.sb = subBitmap;
        this.x1_org = this.x1 = this.sb.x;
        this.y1_org = this.y1 = this.sb.y;
        this.x2_org = this.x2 = this.sb.x + this.sb.width;
        this.y2_org = this.y2 = this.sb.y + this.sb.height;
        this.frame = new JFrame(Language.get("WIN_SBMP_EDIT_TITLE"));
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLayout(new BorderLayout());
        this.zoom_panel = new JPanel();
        this.zoom_panel.setLayout(new FlowLayout());
        this.zoom_less = new JButton("-");
        this.zoom_less.addActionListener(this);
        this.zoom_panel.add(this.zoom_less);
        this.zoom_label = new JLabel(Language.get("ZOOM_FACTOR") + " 1x");
        this.zoom_panel.add(this.zoom_label);
        this.zoom_more = new JButton("+");
        this.zoom_more.addActionListener(this);
        this.zoom_panel.add(this.zoom_more);
        this.zoom_panel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.frame.add((Component)this.zoom_panel, "First");
        this.p_width = this.b.image.getWidth();
        this.p_height = this.b.image.getHeight();
        this.setPreferredSize(new Dimension(this.p_width, this.p_height));
        this.scroll_pane = new JScrollPane(this);
        this.scroll_pane.setPreferredSize(new Dimension(this.p_width + 20, this.p_height + 20));
        this.frame.add((Component)this.scroll_pane, "Center");
        this.frame.pack();
        this.frame.setLocation(this.sb.frame.getX() + this.sb.frame.getWidth() + 5, this.sb.frame.getY());
        this.frame.setMinimumSize(new Dimension(200, 100));
        this.frame.setVisible(true);
        this.fu = new FrameUpdater(this, 25);
        this.fu.start();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.b.image == null) {
            return;
        }
        if (this.drawcount >= 30) {
            this.drawcount = 0;
        }
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.b.image, 0, 0, this.p_width * this.z_fact, this.p_height * this.z_fact, this.frame);
        graphics.setColor(Color.RED);
        int[] nArray = new int[]{this.x1 * this.z_fact, this.x2 * this.z_fact, this.x2 * this.z_fact, this.x1 * this.z_fact};
        int[] nArray2 = new int[]{this.y1 * this.z_fact, this.y1 * this.z_fact, this.y2 * this.z_fact, this.y2 * this.z_fact};
        if (this.drawcount <= 20 || this.starteddragging) {
            graphics.drawPolygon(nArray, nArray2, 4);
        }
        ++this.drawcount;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.starteddragging) {
            if (!this.contains(mouseEvent.getPoint())) {
                return;
            }
            this.starteddragging = true;
            this.x1_org = this.x1;
            this.y1_org = this.y1;
            this.x2_org = this.x2;
            this.y2_org = this.y2;
            this.x2 = this.x1 = mouseEvent.getX() / this.z_fact;
            this.y2 = this.y1 = mouseEvent.getY() / this.z_fact;
        } else {
            this.x2 = mouseEvent.getX() / this.z_fact >= this.p_width ? this.p_width : (mouseEvent.getX() / this.z_fact < 0 ? 0 : mouseEvent.getX() / this.z_fact);
            this.y2 = mouseEvent.getY() / this.z_fact >= this.p_height ? this.p_height : (mouseEvent.getY() / this.z_fact < 0 ? 0 : mouseEvent.getY() / this.z_fact);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.starteddragging) {
            this.starteddragging = false;
            if (this.x2 > this.x1) {
                this.sb.x_tf.setText(String.valueOf(this.x1));
                this.sb.width_tf.setText(String.valueOf(this.x2 - this.x1));
            } else {
                this.sb.x_tf.setText(String.valueOf(this.x2));
                this.sb.width_tf.setText(String.valueOf(this.x1 - this.x2));
            }
            if (this.y2 > this.y1) {
                this.sb.y_tf.setText(String.valueOf(this.y1));
                this.sb.height_tf.setText(String.valueOf(this.y2 - this.y1));
            } else {
                this.sb.y_tf.setText(String.valueOf(this.y2));
                this.sb.height_tf.setText(String.valueOf(this.y1 - this.y2));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void updateDimensions() {
        if (!this.starteddragging) {
            try {
                this.x1 = Integer.parseInt(this.sb.x_tf.getText());
                this.x2 = this.x1 + Integer.parseInt(this.sb.width_tf.getText());
                this.y1 = Integer.parseInt(this.sb.y_tf.getText());
                this.y2 = this.y1 + Integer.parseInt(this.sb.height_tf.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.updateDimensions();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.updateDimensions();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.sb.destroyEditWindow();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.zoom_less)) {
            if (this.z_fact > 1) {
                --this.z_fact;
            }
            this.zoom_label.setText(Language.get("ZOOM_FACTOR") + " " + this.z_fact + "x");
            this.setSize(this.p_width * this.z_fact, this.p_height * this.z_fact);
            this.setPreferredSize(new Dimension(this.p_width * this.z_fact, this.p_height * this.z_fact));
        } else if (actionEvent.getSource().equals(this.zoom_more)) {
            if (this.z_fact < 16) {
                ++this.z_fact;
            }
            this.zoom_label.setText(Language.get("ZOOM_FACTOR") + " " + this.z_fact + "x");
            this.setSize(this.p_width * this.z_fact, this.p_height * this.z_fact);
            this.setPreferredSize(new Dimension(this.p_width * this.z_fact, this.p_height * this.z_fact));
        }
    }
}

