/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{}

var Dir = new function ()
{
    this.toNativeSeparator = function (path)
    {
        path = path.replace(/\/\//g, '/');
        if (systemInfo.productType === "windows")
            return path.replace(/\//g, '\\');
        return path;
    }
};

Component.prototype.createOperations = function()
{
    component.createOperations();
    try {
        var qtPath = "@TargetDir@" + "/6.7.3/macos";
        var qmakeBinary = "@TargetDir@" + "/6.7.3/macos/bin/qmake";

        if (installer.value("SDKToolBinary") == "")
            return;

        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addQt",
                                "--id", component.name,
                                "--name", "Qt %{Qt:Version} for macOS",
                                "--type", "Qt4ProjectManager.QtVersion.Desktop",
                                "--qmake", qmakeBinary,
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmQt", "--id", component.name]);

        var kitName = component.name + "_kit";
        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addKit",
                                "--id", kitName,
                                "--name", "Qt %{Qt:Version} for macOS",
                                "--Ctoolchain", "x86-macos-generic-mach_o-64bit",
                                "--Cxxtoolchain", "x86-macos-generic-mach_o-64bit",
                                "--qt", component.name,
                                "--debuggerengine", "256", // DebuggerEngineType::LldbEngineType
                                "--devicetype", "Desktop",
                                "UNDOEXECUTE", "{0,2}",
                                "@SDKToolBinary@", "rmKit", "--id", kitName]);

        // create qt.conf file
        createQtConfFiles(component, installer.value("TargetDir") + "/6.7.3/macos", "Qt-6.7.3");

        // is this OpenSource installation?
        var isOpenSource = "true";
        if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
            // patch qconfig.pri
            var qconfigFile = qtPath + "/mkspecs/qconfig.pri";
            component.addOperation("LineReplace", qconfigFile, "QT_EDITION =", "QT_EDITION = OpenSource");
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck_mac", "QT_LICHECK =");
        }

    } catch(e) {
        print(e);
    }
}


